const path = require('path');

const express = require('express');
const app = express();
const PORT = 3000;

const { products } = require('./data/product-data.js');
let { messages, messageCount } = require('./data/product-data.js');

app.set("view engine", "pug");
app.set("views", path.join(__dirname, "views"));

app.use(express.urlencoded( { extended: false }));

app.use(express.static(__dirname));

app.get(["/", "/home", "/index"], (req, res) => {
    res.render("pages/index", { products, currentPage: "home"});
});
app.get(["/about"], (req, res) => {
    res.render("pages/about", { products, currentPage: "about"});
});
app.get(["/contact"], (req, res) => {
    res.render("pages/contact", { products, currentPage: "contact"});
});
app.get(["/products"], (req, res) => {
    res.render("pages/products", { products, currentPage: "products"});
});
app.get(["/product"], (req, res) => {
    const id = parseInt(req.query.id);
    const prod = products[id-1];
    if (!prod) 
        return res.status(404).send("Product Not Found");
    res.render("pages/product", { prod, currentPage: "products"});
});

app.post("/contact/message", (req, res) => {
    messages.push(req.body);
    messageCount++;
    res.render("pages/messageReceived");
});

app.use((req, res) => {
    return res.status(404).send("Not Found");
})

app.listen(PORT);
console.log(`Server running at http://localhost:${PORT}`);