const PORT=3000;

const express = require('express');
const app = express();
app.set("view engine", "pug");

// app.locals = a storage for local server information
// app.locals.config becomes a globally-accessable variable containing our config info
app.locals.config = require("./config.json");


// Serve static files (e.g., style.css, logo.jpg)
app.use(express.static(__dirname));


// Require and mount the 3 routers (one for each main type of resource)
let userRouter = require("./routers/user-router");
app.use("/users", userRouter);

let productsRouter = require("./routers/products-router");
app.use("/products", productsRouter);

let reviewsRouter = require("./routers/reviews-router");
app.use("/reviews", reviewsRouter);



// Respond with home page data if requested
app.get("/", (req, res, next) => { 
    res.render("pages/index"); 
});


app.listen(PORT);
console.log("Server listening at http://localhost:" + PORT);
