// This code is a simple test program that will connect to a database display its collections and then quit

// Get the database connect/disconnect functions 
const { connectToDatabase, disconnectFromDatabase } = require("./db");

// We made a main() function because we are required to use "async"
async function main() {
    try {
        const db = await connectToDatabase();

        const collections = await db.collections();
        console.log("Collections:", collections.map(c => c.collectionName));

    } catch (err) {
        console.error("Error ... something went wrong:", err);
    } finally {
        await disconnectFromDatabase();
    }
}

main();