
const { MongoClient } = require("mongodb");

const url = "mongodb://localhost:27017";
const dbName = "myDatabase";

const client = new MongoClient(url);

let db = null;

async function connectToDatabase() {
    if (!db) {
        try {
            await client.connect();
            console.log("Connected to MongoDB: " + dbName);
            db = client.db(dbName);
        } catch(err) {
            console.error("Error connecting to MongoDB: ", err);
            throw err;
        }
    }
    return db;
}

async function disconnectFromDatabase() {
    try {
        await client.close();
        console.log("Disconnected from MongoDB: " + dbName);
        db = null;
    } catch(err) {
        console.error("Error disconnecting from MongoDB: ", err);
    }
}

module.exports = { connectToDatabase, disconnectFromDatabase };
