
const { connectToDatabase, disconnectFromDatabase } = require("./db");

async function main() {
    try {
        const db = await connectToDatabase();
        const collections = await db.collections();
        console.log("Collections: ", collections.map(c => c.collectionName));
    } catch(err) {
        console.log("Error ... something went wrong: ", err);
    } finally {
        await disconnectFromDatabase();
    }
}


main();
