// This code will connect to a database add some toys to a products collection and then perform some queries/updates and then quit.

// Get the database connect/disconnect functions 
const { connectToDatabase, disconnectFromDatabase } = require("./db");

// Here are some toys that we will insert
const toys = [
  { _id: 1, name: "LEGO Classic Bricks", category: "Building", price: 29.99, stock: 120, ageRange: "4+"},
  { _id: 2, name: "Barbie Dreamhouse", category: "Dolls", price: 199.99, stock: 25, ageRange: "3+"},
  { _id: 3, name: "Hot Wheels Track Set", category: "Vehicles", price: 49.99, stock: 75, ageRange: "5+"},
  { _id: 4, name: "NERF Blaster Elite", category: "Outdoor", price: 39.99, stock: 60, ageRange: "8+"},
  { _id: 5, name: "Play-Doh Party Pack", category: "Arts & Crafts", price: 12.99, stock: 200, ageRange: "3+"},
  { _id: 6, name: "Rubik’s Cube", category: "Puzzles", price: 9.99, stock: 150, ageRange: "6+"}
];

// We made a main() function because we are required to use "async"
async function main() {
    try {
        const db = await connectToDatabase();

        const products = db.collection("products");

        //let result = await products.insertMany(toys);
        //console.log(result.insertedCount + " products were added.");

        let prods = await products.find();
        console.log("Here are the products:");
        for await (const p of prods) {
            console.log(p);
        }

        let cheap = await products.find( { price: {$lt:30}});
        console.log("Here are the products under $30:");
        for await (const p of cheap) {
            console.log(p);
        }

        result = await products.updateOne( { name: "Barbie Dreamhouse"}, {$set: {price: 179.99}});
        if (result.acknowledged)
            console.log("Price drop for BD");
        else
            console.log("Price not dropped for BD");

        let product = await products.find( { name: "Barbie Dreamhouse" });
        let p = (await product.next()).price;
        console.log("BD costs $", p);
     
        /*result = await products.replaceOne( {_id: 4}, 
            { _id: 4, name: "Monster Truck", category: "Remote Control", price: 59.99, stock: 40, ageRange: "10+"}
        );
        if (result.acknowledged)
            console.log("Nerf blaster replaced with monster truck");
        else
            console.log("Nerf blaster not replaced with monster truck");

        prods = await products.find();
        console.log("Here are the products:");
        for await (const p of prods) {
            console.log(p);
        }*/

    } catch (err) {
        console.error("Error ... something went wrong:", err);
    } finally {
        await disconnectFromDatabase();
    }
}

main();