const crypto = require('crypto');
const express = require('express');
const app = express();
const PORT = 3000;


// This is where we will store all session information
const sessions = {};

// Helper function to parse the cookies
function parseCookies(cookieHeader) {
    const cookies = {}; 
    if (!cookieHeader) 
        return cookies;
    cookieHeader.split(';').forEach(pair => {
        const [name, value] = pair.trim().split('=');
        cookies[name] = value;
    });
    return cookies;
}

// Sample route to /visit URL
app.get('/visit', (req, res) => {
    const cookies = parseCookies(req.headers.cookie);
    let sessionId = cookies.sessionId;

    // If there is no session or this will be a new one, create one
    if (!sessionId || !sessions[sessionId]) {
        const sessionId = crypto.randomBytes(16).toString('hex'); // 32 hex characters (128 bits)
        sessions[sessionId] = { views: 1 };
        res.setHeader('Set-Cookie', `sessionId=${sessionId}; HttpOnly; Path=/`);
        res.send('You have visited this page 1 time');
    } else {
        // Increment existing session views
        sessions[sessionId].views++;
        res.send(`You have visited this page ${sessions[sessionId].views} times`);
    }
});

app.listen(PORT);
console.log("Server listening on port " + PORT);