const crypto = require('crypto');
const express = require('express');
const app = express();
const PORT = 3000;
const cookieParser = require('cookie-parser');

// This is where we will store all session information
const sessions = {};

// Use cookie-parser middleware
app.use(cookieParser());

// Sample route to /visit URL
app.get('/visit', (req, res) => {
    let sessionId = req.cookies.sessionId;

    // If there is no session or this will be a new one, create one
    if (!sessionId || !sessions[sessionId]) {
        const sessionId = crypto.randomBytes(16).toString('hex'); // 32 hex characters (128 bits)
        sessions[sessionId] = { views: 1 };

        // Set the cookie with HttpOnly and Secure flags
        res.cookie('sessionId', sessionId, {
            httpOnly: true,
            secure: false,  // allow cookies over HTTP (needed for localhost dev)
            path: '/'
        });
        res.send('You have visited this page 1 time');
    } else {
        // Increment existing session views
        sessions[sessionId].views++;
        res.send(`You have visited this page ${sessions[sessionId].views} times`);
    }
});

app.listen(PORT);
console.log("Server listening on port " + PORT);
