const express = require('express');
const app = express();
const PORT = 3000;

const session = require('express-session');

// Use express-session middleware
app.use(session({
    secret: 'mySecretKey',       // used to sign the session ID cookie
    resave: false,               // don't save session if unmodified
    saveUninitialized: true,     // create session for new clients
    cookie: {
        httpOnly: true,
        secure: false,          // allow cookies over HTTP (needed for localhost dev)
        path: '/'
    }
}));

// Sample route to /visit
app.get('/visit', (req, res) => {
    // If 'views' does not exist in session, initialize it
    if (!req.session.views) {
        req.session.views = 1;
        res.send('You have visited this page 1 time');
    } else {
        // Increment existing session views
        req.session.views++;
        res.send(`You have visited this page ${req.session.views} times`);
    }
});

app.listen(PORT);
console.log("Server listening on port " + PORT);