
const express = require('express');
const session = require('express-session'); // We will need npm install express-session
const app = express();
const PORT = 3000;

let users = {
    "amy":   { password: "1234",   admin: true },   
    "raj":   { password: "india",  admin: false },
    "yuki":  { password: "sakura", admin: false },
    "omar":  { password: "desert", admin: true },
    "lia":   { password: "flor",   admin: false }
};

// Tell Express to use Pug as the template engine for rendering views
app.set('view engine', 'pug');

// Use the express-session middleware
app.use(session({
	secret: 'f93^A7z!9uBv#2QpX0kLm@4sWrT8&dEe', // This can be anything
	//cookie: {maxAge:50000},                   // Expire in 50 seconds
	resave: false,                              // Do not save session every time
	saveUninitialized: true                     // Create session upon connection
})); 

// Serve the static homepage in the public directory
app.use(express.static("public"));

// Middleware that lets us use req.body for incoming form query data
app.use(express.urlencoded({ extended: true }));



// Serve login page as the default route
app.get("/", (req, res) => {
    res.render("login");
});

// Send POST request to /login route to our login function
app.post("/login", (req, res) => {
    const { username, password } = req.body;

    // Perform authentication
    if (!users[username] || users[username].password !== password) {
        res.render("login", { error: "Invalid credentials" });
        return;
    }
    req.session.username = username;

    // Decide whether to show the Admin Dashboard page or the regular user page
    if (users[username].admin) {
        // Redirect to the admin page instead of just rendering, since we need to build
        // up the lists of active and registered users first.
        res.redirect("/admin"); 
    } else {
        // Redirect to welcome page to have /welcome route
        res.redirect("/welcome");
    }
});      

// Send GET request to /logout route to our logout function
app.get("/logout", (req, res) => {
    req.session.destroy(err => {
        res.redirect("/");
    });
});

// Handle /admin route  
app.get("/admin", auth, (req, res) => {
    // Get all registered users
    const registeredUsers = Object.keys(users);

    // Get all active users (i.e., anyone with a session + username)
    const activeUsers = [];
    const sessions = req.sessionStore.sessions;
    const sessionKeys = Object.keys(sessions);

    for (let i=0; i<sessionKeys.length; i++) {
        const sessionId = sessionKeys[i];
        const sessionData = JSON.parse(sessions[sessionId]);

        if (sessionData.username && !activeUsers.includes(sessionData.username)) {
            activeUsers.push(sessionData.username);
        }
    }

    res.render("admin", {
        username: req.session.username,
        registeredUsers,
        activeUsers
    });
});

// Handle /welcome route 
app.get("/welcome", (req, res) => {
    // If not logged in, go back to the home page
    if (!req.session.username) {
        res.redirect("/");
        return;
    }
    // Otherwise render the user.pug page
    res.render("user", { username: req.session.username });
});

// Our Authorization function
function auth(req, res, next) {
	// Check if there is a username property set for the session, and if they have admin rights
	if (!req.session.username || !users[req.session.username].admin) {
		res.status(401).send("Unauthorized");
		return;
	}
	next();
}

app.listen(PORT);
console.log("Server listening on port " + PORT);
