
const mongoose = require("mongoose");
const Schema = mongoose.Schema;

let productSchema = Schema({
    name: { type: String, required: true, trim: true, minlength: 2, maxlength: 100 },
    price: { type: Number, required: true, min: 0 },
    stock: { type: Number, default: 0, min: 0 },
    dimensions: { 
        length: { type: Number, min: 0 }, 
        width: { type: Number, min: 0 }, 
        height: { type: Number, min: 0 } },
    weight: { type: Number, min: 0 }
});

module.exports = mongoose.model("Product", productSchema);
