const mongoose = require("mongoose");

const toyProductSchema = new mongoose.Schema({
    name: {
        type: String,
        required: [true, "Product name is required"],
        trim: true,
        minlength: [2, "Name must be at least 2 characters long"],
        maxlength: [50, "Name cannot exceed 50 characters"]
    },
    category: {
        type: String,
        required: true,
        enum: ["Building", "Dolls", "Vehicles", "Outdoor", "Arts & Crafts", "Puzzles", "Remote Control"]
    },
    price: {
        type: Number,
        required: true,
        min: [0.01, "Price must be greater than zero"],
        max: [1000, "Price must be less than $1000"]
    },
    stock: {
        type: Number,
        required: true,
        min: [0, "Stock cannot be negative"],
        validate: {
            validator: Number.isInteger,
            message: "Stock must be an integer"
        }
    },
    ageRange: {
        type: String,
        required: true,
        match: [/^\d+\+$/, "Age range must be in the format 'N+' (e.g., '3+')"]
    }
});

module.exports = mongoose.model("ToyProduct", toyProductSchema);


