// Get the mongoose module
const mongoose = require("mongoose");

const dbName = "websiteDatabase"; // Name of our database
const url = "mongodb://localhost:27017/" + dbName; // database name part of URL now

// Connect to the database
async function connectToDatabase() {
    if (mongoose.connection.readyState !== 1) { // 1 = connected
        try {
            await mongoose.connect(url);
            console.log("Connected to MongoDB: " + dbName);
        } catch (err) {
            console.error("Error connecting to MongoDB:", err);
            throw err; // re-throw this error so that the caller knows it failed
        }
    }
    return mongoose.connection;
}

// Disconnect from the database
async function disconnectFromDatabase() {
    try {
        await mongoose.disconnect();
        console.log("Disconnected from MongoDB: " + dbName);
    } catch (err) {
        console.error("Error disconnecting from MongoDB:", err);
    }
}

module.exports = { connectToDatabase, disconnectFromDatabase };
