const mongoose = require("mongoose");
const db = require("./mongooseDB.js"); // Our connection code shown earlier

const Product = require("./ProductModel");

async function main() {
    let connection;
    try {
        // Connect to database
        connection = await db.connectToDatabase();

        // Fetch all products
        const products = await Product.find();
        console.log(products);
    } catch (err) {
        console.error("Error fetching products:", err);
    } finally {
        // Disconnect
        await db.disconnectFromDatabase();
    }
}

main();
