
const mongoose = require("mongoose");
const Schema = mongoose.Schema;

const reviewSchema = new mongoose.Schema({
    user: { type: mongoose.Schema.Types.ObjectId, required: true, ref: 'User' },
    rating: { type: Number, required: true, min: 1, max: 5 },
    comment: { type: String, maxlength: 1000 },
    date: { type: Date, default: Date.now }
});

let productSchema = Schema({
    name: { type: String, required: true, trim: true, minlength: 2, maxlength: 100 },
    price: { type: Number, required: true, min: 0 },
    stock: { type: Number, default: 0, min: 0 },
    dimensions: { 
        length: { type: Number, min: 0 }, 
        width: { type: Number, min: 0 }, 
        height: { type: Number, min: 0 } },
    weight: { type: Number, min: 0 },
    reviews: [reviewSchema],
    ageRange: { type: String, required: true, match: [/^\d+\+$/, "must be in format '3+' "] }
});



module.exports = mongoose.model("Product", productSchema);
