let utensils = ["fork", "spoon", "knife"];
let empty = [];   // empty array
let numbers = [1, 2, 3];
let mixed = ["bot", 42, false];

numbers[2];		// returns 3
numbers[3] = 7;	// changes the array to [1, 2, 7]
numbers[8] = 5;	// array now [1, 2, 3, 7, <4 empty items>, 5]
console.log(numbers);
console.log(numbers[9]);

console.log("\n\n");

console.log(utensils);
console.log(utensils.length);
console.log(utensils.sort());               // sorts the items
console.log(utensils.reverse());            // reverses the items
console.log(utensils);
console.log(utensils.push("whisk"));	    // adds "whisk" to the end
console.log(utensils);
console.log(utensils.pop()); 			    // removes "whisk" from the end
console.log(utensils);
console.log(utensils.shift()); 		        // removes "fork" from the front
console.log(utensils);
console.log(utensils.unshift("tongs"));	    // adds "tongs" to the front
console.log(utensils);
console.log(utensils.includes("knife"));    // checks if "knife" is in there
console.log(utensils);
console.log(utensils.indexOf("spoon"));     // returns its index (starting at 0)
console.log(utensils);

console.log("\n\n");

let firstTwo = utensils.slice(0, 2);        // extract items from 0 to 1
console.log(firstTwo);

utensils.splice(1, 1, "ladle"); 	        // replace 2nd item with "ladle"
console.log(utensils);

utensils.splice(2, 2, "fork", "chopsticks"); 
console.log(utensils);


console.log(utensils.join(", "));
console.log(utensils.join("|"));


utensils = ["fork", "spoon", "knife"];

utensils.forEach(utensil => console.log(utensil));

let uppercased = utensils.map(t => t.toUpperCase());
console.log(uppercased);
console.log(utensils);


let longNames = utensils.filter(t => t.length > 4);
console.log(longNames);

let found = utensils.find(u => u.startsWith("s"));
console.log(found);

utensils = ["fork", "spoon", "knife"];
let result = utensils.reduce((returnString, item) => {
  return returnString + ", " + item;
}, "Combined Items: ");
console.log(result);  // "fork, spoon, knife"

utensils = ["fork", "spoon", "knife"];
let obj = utensils.reduce((returnObject, item) => {
  returnObject[item] = 1;
  return returnObject;
}, {});  // initial value is a new empty object
console.log(obj);  // "fork, spoon, knife"

const fruits = ["apple", "banana", "cherry"];

for (const fruit of fruits) {
    console.log(fruit);  
}

