console.log(Number("123"));			// 123
console.log(Number("456.78"));		// 456.78
console.log(parseInt("42px"));  	// 42
console.log(parseFloat("56.7'"));	// 56.7
console.log(+"100");				// 100
console.log(+"544.36");			    // 544.36
console.log(Number(true));			// 1
console.log(Number(false));			// 0
console.log(Number("abc"));			// NaN

console.log(String(123));			// "123"
console.log(String(456.78));		// "456.78"
console.log((123).toString());		// "123"
console.log((456.78).toString());	// "456.78"
console.log((456.78).toFixed(0));	// "457"
console.log((456.78).toFixed(1));	// "456.8"
console.log((456.78).toFixed(3));	// "456.780"
console.log((456.78).toString());	// "456.78"
console.log(String(true));			// "true"

console.log("5" + 1);               // "51" ...  number is coerced to string
console.log(true + "1");            // "true1"
console.log(null + "test");         // "nulltest"

console.log("10" - 2);              // 8 ...  "10" becomes number
console.log("4" * "2");             // 8 ...  both strings become numbers
console.log(true * 2);              // 2 ...  true becomes 1
console.log(null + 1);              // 1 ...  null becomes 0
console.log("abc" - 1);             // NaN ...  "abc" can't be a number
console.log(undefined + 1);		    // NaN + 1 = NaN
console.log(true + true + 3);	    // 1 + 1 + 3 = 5

console.log("\n");

console.log(5 == "5");			    // true ...  converts "5" to number 5
console.log(0 == false);		    // true	...  converts false to 0
console.log(1 == true);			    // true ...  the true becomes a 1
console.log(null == undefined);	    // true ...  special case in JS
console.log(NaN == NaN);		    // false ... NaN is never equal to NaN
console.log("0" == false);		    // true ...  "0" becomes 0, false becomes 0
console.log([] == false);		    // true ...  [] becomes "", then 0
console.log([] == "");			    // true ...  [] becomes ""
console.log([1] == 1);			    // true ...  [1] becomes "1", then number 1
console.log({} == {});			    // false ...  different object references
console.log(null == 0);			    // false ...  no coercion to 0
console.log(undefined == 0);		// false ...  not converted to 0

console.log("\n");

console.log(5 === "5");			    // true ...  converts "5" to number 5
console.log(0 === false);		    // true	...  converts false to 0
console.log(1 === true);			// true ...  the true becomes a 1
console.log(null === undefined);	// true ...  special case in JS
console.log(NaN === NaN);		    // false ... NaN is never equal to NaN
console.log("0" === false);		    // true ...  "0" becomes 0, false becomes 0
console.log([] === false);		    // true ...  [] becomes "", then 0
console.log([] === "");			    // true ...  [] becomes ""
console.log([1] === 1);			    // true ...  [1] becomes "1", then number 1
console.log({} === {});			    // false ...  different object references
console.log(null === 0);			// false ...  no coercion to 0
console.log(undefined === 0);	    // false ...  not converted to 0

console.log("\n");

console.log(false ?  true : false);     // false
console.log(0 ?  true : false);         // false
console.log("" ?  true : false);        // false
console.log(null ?  true : false);      // false
console.log(undefined ?  true : false); // false
console.log(NaN ?  true : false);       // false
