
let robot1 = {
    name: "XR-17",
    model: "Explorer",
    age: 5,
    "can fly": false
};

let robot2 = {
    name: "Coptor",
    model: "drone Y-8",
    age: 2,
    "can fly": true
};

function newest(r1, r2) {
    if (r1.age < r2.age) 
        return r1;
    return r2;
}

function crash(r) {
    r["can fly"] = false; // access the attribute via []
}

console.log(newest(robot1, robot2)); // both objects passed by reference

console.log(robot2);
crash(robot2);          // alters original
console.log(robot2);

console.log("\n\n\n");

let robot3 = {
    name: "R2D2",
    model: "Droid",
    age: 12,
    battery: 60,   // percentage
    equippedTools: ["scanner", "welder"],
    missionCount: 12
};

function prepareMissionProfile(r) {
    let c = { ...r };
    c.battery = 100;               // fully charge for the mission
    c.equippedTools.push("drill"); // equip with an extra tool
    c.missionCount += 1;           // add one to number of missions

    return c;
}

let simulatedRobot = prepareMissionProfile(robot3);

console.log(simulatedRobot);

crash(robot2);          // alters original

console.log(robot3);

console.log("\n\n\n");




let original = [1, 2, 3];
let copy = [...original];

copy.push(4);

console.log(original); // [1, 2, 3]
console.log(copy);     // [1, 2, 3, 4]
console.log("\n\n\n");




let word = "hello";
let letters = [...word]; 	// ['h', 'e', 'l', 'l', 'o']

console.log(letters);
console.log("\n\n\n");




let info = { name: "Steve" };
let job = { role: "Developer" };
let profile = { ...info, ...job }; // { name: "Steve", role: "Developer" }

console.log(profile);
console.log("\n\n\n");





let newRobot = Object.assign({}, robot1);
newRobot.age = 23;
console.log(robot1.age);    // 5
console.log(newRobot.age);  // 23

let newerRobot = JSON.parse(JSON.stringify(robot1));

console.log(JSON.stringify(robot1));    // {"name":"XR-17","model":"Explorer","age":5,"can fly":false}


