let slider = document.getElementById('imageSlider');
let dots = document.querySelectorAll('.dot');
let totalSlides = dots.length;
let currentIndex = 0;
let slideInterval;

function goToSlide(index) {
    currentIndex = index;
    slider.style.transform = `translateX(-${index * 800}px)`;
    dots.forEach(dot => dot.classList.remove('active'));
    dots[index].classList.add('active');
}

function nextSlide() {
    currentIndex = (currentIndex + 1) % totalSlides;
    goToSlide(currentIndex);
}

function startSlideShow() {
    slideInterval = setInterval(nextSlide, 2500);
}

// Stop slideshow when user clicks dot
dots.forEach(dot => {
    dot.addEventListener('click', (e) => {
        clearInterval(slideInterval);
        goToSlide(parseInt(e.target.dataset.slide));
        startSlideShow();
    });
});


// Initialize
goToSlide(0);
startSlideShow();