
// 1. Get the alert element and read the class name
let alertElement = document.getElementById("class-demo");
console.log("Initial classes:", alertElement.className);


// 2. After 1 second, add the "hidden" class to the element)
setTimeout(() => {
    alertElement.classList.toggle("hidden");
    console.log("Initial classes:", alertElement.className);
}, 1000);


// 3. After another second, add a highlight class and show it
setTimeout(() => {
    alertElement.classList.add("highlight");   // Now has "alert highlight"
    alertElement.classList.toggle("hidden");   
    console.log("Initial classes:", alertElement.className);
}, 2000);


// 4. After, yet another scond, set inline styles directly
// to make a green order, light purple background and padding
setTimeout(() => {
    alertElement.style.backgroundColor = "#eef";
    alertElement.style.border = "2px solid green";
    alertElement.style.borderWidth = "5px";
    alertElement.style.padding = "1em";
    alertElement.style.marginTop = "1em";
}, 3000);


// 5. After yet another second, read inline style
setTimeout(() => {
    console.log("Inline backgroundColor:", alertElement.style.backgroundColor);
    console.log("Inline borderWidth:", alertElement.style.borderWidth);
    
    let computed = window.getComputedStyle(alertElement);
    console.log("Computed padding:", computed.padding);
    console.log("Computed font-weight:", computed.fontWeight);  // 700
}, 4000);
