// 1. Adding items to a list
let newItem = document.createElement("li");
newItem.textContent = "New list item added";
document.getElementById("list-demo").appendChild(newItem);




// 2. Removing a part of the page
let clearPortion = document.getElementById("clear-demo");
clearPortion.parentNode.remove();




// 3 Adding a table section
// 3a. Sample user data
const users = [
    { name: "Dave Johnson", email: "dave@gmail.com" },
    { name: "Bob Smith", email: "bob@yahoo.com" },
    { name: "Clara Lee", email: "clara@hotmail.com" }
];

// 3b. Create table element
let table = document.createElement("table");
table.style.borderCollapse = "collapse";
table.style.marginTop = "1em";
table.style.width = "60%";

// 3c. Create table header
let thead = document.createElement("thead");
let headerRow = document.createElement("tr");
["Name", "Email"].forEach(text => {
    const th = document.createElement("th");
    th.textContent = text;
    th.style.border = "1px solid #333";
    th.style.padding = "10px";
    th.style.backgroundColor = "#f0f0f0";
    headerRow.appendChild(th);
});
thead.appendChild(headerRow);
table.appendChild(thead);

// 3d. Create table body
const tbody = document.createElement("tbody");
users.forEach(user => {
    const row = document.createElement("tr");

    const nameCell = document.createElement("td");
    nameCell.textContent = user.name;
    nameCell.style.border = "1px solid #333";
    nameCell.style.padding = "8px";

    const emailCell = document.createElement("td");
    emailCell.textContent = user.email;
    emailCell.style.border = "1px solid #333";
    emailCell.style.padding = "8px";

    row.appendChild(nameCell);
    row.appendChild(emailCell);
    tbody.appendChild(row);
});
table.appendChild(tbody);

// 3e. Create section wrapper
const section = document.createElement("section");

// 3f. Create heading
const heading = document.createElement("h2");
heading.textContent = "9. User Table";

// 3g. Append heading and table to section
section.appendChild(heading);
section.appendChild(table);

// 3h. Append the section to the body
document.body.appendChild(section);