// 1. Change Text Content
let button = document.getElementById("click-demo");

button.addEventListener("click", function () {
    alert("Button clicked! Event handler is working.");
});




// 2. Display a different "loadingImage" while the image is loading
document.addEventListener("DOMContentLoaded", function () {
    // 2a. First, change the current image to a slow loading one:
    let image = document.getElementById("image-demo");
    
    // We will add a timeout to “fake” the slow loading of the image
    setTimeout(() => {
        image.setAttribute("src", "https://vastphotos.com/files/uploads/photos/12190/jackson-wyoming-photo-vast-xl.jpg?v=20250505092014");
    }, 3000);

    // 2b. Create a wrapper div to hold the image and loadingImage
    const wrapper = document.createElement("div");
    wrapper.style.position = "relative";
    wrapper.style.display = "inline-block";
    wrapper.style.width = image.width + "px"; // match image size if needed
    wrapper.style.height = image.height + "px";

    // 2c. Insert wrapper into DOM and move image into it
    image.parentNode.insertBefore(wrapper, image);
    wrapper.appendChild(image);

    // 2d. Create and insert image to show when loading
    const loadingImage = document.createElement("img");
    loadingImage.src = "loading_icon.gif"; 
    loadingImage.alt = "Loading...";
    loadingImage.style.position = "absolute"; // spinner is on the image 
    loadingImage.style.top = "50%"; // centered on the original image
    loadingImage.style.left = "50%";
    loadingImage.style.transform = "translate(-50%, -50%)";
    loadingImage.style.width = "100px";
    loadingImage.style.height = "100px";
    wrapper.appendChild(loadingImage);

    // 2e. Hide image initially until it's loaded
    image.style.display = "none";

    // 2f. When image loads, show it and remove loadingImage
    image.addEventListener("load", function () {
        loadingImage.remove();
        image.style.display = "block";
    });

    // 2g. Optional: handle loading failure
    image.addEventListener("error", function () {
        loadingImage.remove();
        const errorMsg = document.createElement("p");
        errorMsg.textContent = "Image failed to load.";
        wrapper.appendChild(errorMsg);
    });
});