let url = require("url");
let urlString = 'http://localhost:3000/index.html?year=2022&month=october#content';
let q = url.parse(urlString, true);     // true indicates to parse the query into an object

console.log("href: ", 	  q.href);      // http://localhost:3000/index.html?year=2022&month=october#content
console.log("host: ", 	  q.host);      // localhost:3000
console.log("hostname: ", q.hostname);  // localhost
console.log("port: ", 	  q.port);      // 3000
console.log("path: ", 	  q.path);      // /index.html?year=2022&month=october
console.log("pathname: ", q.pathname);  // /index.html
console.log("search: ",   q.search);    // ?year=2022&month=october
console.log("hash: ", 	  q.hash);      // #content

let qdata = q.query;                    // returns the query portion of the URL
console.log(qdata);                     // { year: 2022, month: 'october' }
console.log(qdata.month);               // october

for (x in qdata) {
    console.log(x + ": " + qdata[x]);   // year: 2022 and month: october
}
