// Fun Fact logic
const facts = [
    "The first website went online in 1991.",
    "JavaScript was created in just 10 days.",
    "JSON stands for JavaScript Object Notation.",
    "AJAX doesn't require reloading the whole page.",
    "XMLHttpRequest was introduced in Internet Explorer 5."
];
let factBtn = document.getElementById("factBtn");
let factOutput = document.getElementById("factOutput");

factBtn.addEventListener("click", function () {
    let randomIndex = Math.floor(Math.random() * facts.length);
    factOutput.textContent = facts[randomIndex];
});


// Load team members into dropdown
let dropdown = document.getElementById("memberDropdown");
let xhrList = new XMLHttpRequest();
xhrList.open("GET", "https://jsonplaceholder.typicode.com/users", true);
xhrList.onload = function () {
    if (xhrList.status === 200) {
        let members = JSON.parse(xhrList.responseText);
        members.forEach(member => {
            let option = document.createElement("option");
            option.value = member.id;
            option.textContent = member.name;
            dropdown.appendChild(option);
        });
        // Add a non-existent member for testing
        let option = document.createElement("option");
        option.value = 0;
        option.textContent = "unknown";
        dropdown.appendChild(option);
    } else {
        console.error("Error loading team member data:", xhrList.status);
        dropdown.innerHTML = "<option disabled>Error loading team members</option>";
    }
};

xhrList.onerror = function () {
    console.error("Network error loading team member list.");
    dropdown.innerHTML = "<option disabled>Error loading team members</option>";
};
xhrList.send();

// Load selected member's profile (with delay)
let xhrmember = null;  // no member data being requested at this time
let delayTimer = null; // stores the timeout ID

dropdown.addEventListener("change", function () {
    let loadingEl = document.getElementById("loading");
    let errorEl = document.getElementById("error");
    let memberCard = document.getElementById("memberCard");

    let memberId = this.value;
    if (!memberId) return;   // stop if the selected member is somehow invalid

    // If a member's data is already being downloaded, then abort() it before sending new request
    if (xhrmember && xhrmember.readyState !== XMLHttpRequest.DONE) {
        xhrmember.abort();
    }
    if (delayTimer) {
        clearTimeout(delayTimer);
        delayTimer = null;
    }

    loadingEl.textContent = "Loading data ... "; // Now show that things are loading
    loadingEl.style.display = "block";           // Make it visible
    errorEl.textContent = "";			         // Hide error until we know if there is one
    memberCard.style.display = "none";           // Hide the card since it is not ready yet


    xhrmember = new XMLHttpRequest();
    xhrmember.open("GET", `https://jsonplaceholder.typicode.com/users/${memberId}`, true);
    xhrmember.onload = function () {
        if (xhrmember.status === 200) {
            let member = JSON.parse(xhrmember.responseText);

            // Keep loading visible until after delay
            delayTimer = setTimeout(() => {
                document.getElementById("cardName").textContent = member.name;
                document.getElementById("cardEmail").textContent = member.email;
                document.getElementById("cardCompany").textContent = member.company.name;
                document.getElementById("cardPhone").textContent = member.phone;
                document.getElementById("cardWebsite").textContent = member.website;

                loadingEl.style.display = "none"; // hide only after showing data
                memberCard.style.display = "block";
            }, 3000); // simulate delay
        } else {
            loadingEl.style.display = "none";
            errorEl.textContent = "Error loading member data (status " + xhrmember.status + ")";
            console.error("Load team member error:", xhrmember.status, xhrmember.responseText);
        }
    };

    xhrmember.onerror = function () {
        loadingEl.style.display = "none";
        errorEl.textContent = "Network error.";
        console.error("Network error during team member fetch.");
    };

    xhrmember.send();
});
