
let questions = [];  // Array of questions

// This will get called after the page loads
function init(){
	document.getElementById("retrieveTests").addEventListener('click', loadQuestions);
}

// This will get the questions from the server
function loadQuestions(){
	let xhr = new XMLHttpRequest();

	// This is only going to get called when the response comes back
	xhr.onload = function() {
		// If the response was successful
		if (xhr.status == 200) {
			// Take the response text (that is in JSON format), parse it into a JS object
			let responseObject = JSON.parse(xhr.responseText);
			// Extract questions from the results and update our array
			questions = responseObject.results;
			// Update our page
			render();
		}
		else { // If the response was not successful, show an error
      		document.getElementById('questiondiv').innerText = `Error: ${xhr.status}`;
    	}
	};

	// Callback function for when a network error occurred
	xhr.onerror = function () {     
    	document.getElementById('questiondiv').innerText = 'Question Database Not Available';
  	};

	//Create and send the request
	xhr.open("GET", "https://opentdb.com/api.php?amount=10&type=multiple", true);
	xhr.send();
}

// This code renders all the received questions on the page as blocks with 4 answers each.
// It then and adds listeners to each answer so that we can handle click events
function render(){
	let content = "";
    let count = 1;

	// Note: Currently, the first answer is the correct answer ... so you may want to shuffle them
	// The code also assumes 4 multiple choice answers each time
	questions.forEach((question, index) => {
		content += `
			<div class="question-block">
				<p> ${count}. Question: ${question.question}</p>
				<label class="answer" data-correct="true">${question.correct_answer}</label><br>
				<label class="answer" data-correct="false">${question.incorrect_answers[0]}</label><br>
				<label class="answer" data-correct="false">${question.incorrect_answers[1]}</label><br>
				<label class="answer" data-correct="false">${question.incorrect_answers[2]}</label>
			</div>
		`
		count++;
	});

	document.getElementById("questiondiv").innerHTML = content;

	// Add event listeners after rendering
	document.querySelectorAll('.answer').forEach(answer => {
  		answer.addEventListener('click', function () {
    		// After the user clicks on an answer, disable further clicks within the same question block
			let block = this.closest('.question-block'); // search up in the DOM to look for this label's question-block
    		block.querySelectorAll('.answer').forEach(a => {
      			a.style.pointerEvents = 'none'; // disable clicks for all questions now
    		});

			// If incorrect, set its class so that the stylesheet can color it as incorrect 
   			if (this.dataset.correct === "false") {
      			this.classList.add('wrong');   
			}

      		// Set the class of the correct answer so that it can be shown 
      		let correctAnswer = block.querySelector('.answer[data-correct="true"]');
      		if (correctAnswer) 
				correctAnswer.classList.add('correct');
  		});
	});
}






// Add event listeners after rendering
document.querySelectorAll('.answer').forEach(answer => {
  	answer.addEventListener('click', function () {
    	// After the user clicks on an answer, disable further clicks within the same question block
		// ...
		// If incorrect, set its class so that the stylesheet can color it as incorrect
		// ...
		// Set the class of the correct answer so that it can be shown 
		// ...
  	});
});

