// Function to handle the Submit Profile button on the main page
function submit() {
	let name = document.getElementById("name");
	if (name.value.length == 0) {
		alert("You must enter a name");
	} else {
		req = new XMLHttpRequest();
		req.onreadystatechange = function() {
			if (this.readyState == 4) {
				if (this.status == 200) {
					alert("Profile Created!");
					name.value = "";
					window.location.href = "/"; // Tell browser to load main page again
				} else {
					alert("Error while trying to create profile. Try again.");
				}
			}
		}
		let person = {name: name.value};
		req.open("PUT", "/newprofile");
		req.send(JSON.stringify(person));
	}
}

// Function to handle the Submit Message button on the profile page
function submitMessage(id) {
	let msg = document.getElementById("msg");
	if (msg.value.length == 0) {
		alert("You must enter a message");
	} else {
		req = new XMLHttpRequest();
		req.onreadystatechange = function() {
			if (this.readyState == 4) {
				if (this.status == 200) {
					alert("Message Sent!");
					msg.value = "";
					window.location.reload(); // Tell browser to load this page again
				} else {
					alert("Error while sending message. Try again.");
				}
			}
		}
		let messageContent = {message: msg.value, id: id};
		req.open("POST", "/message");
		req.send(JSON.stringify(messageContent));
	}
}