export const products = [ 
    {
        name: "SkyCore JetPack", 
        id: 1,
        image: "jetPack.jpg",
        imageSmall: "jetPack_small.jpg",
        desc: "Take to the skies delivering powerful, stable flight that turns gravity into your playground.",
        imageAlt: "SkyCore JetPack",
        par1: "Experience the future of personal flight with the <strong>SkyCore JetPack</strong> — engineered with next-gen quantum propulsion technology for unparalleled speed, agility, and eco-friendly performance. Designed for thrill-seekers and urban adventurers alike, the AeroX Quantum redefines freedom, allowing you to soar effortlessly above the city skyline or explore rugged terrains with ease.",
        par2: "Built with lightweight carbon-titanium alloys and powered by a zero-emission quantum core, this jet pack is not only fast but also sustainable. Integrated AI navigation and safety systems ensure a smooth and secure flight experience, whether you're a beginner or a seasoned pilot.",
        features: [
            {feature: "Quantum Propulsion Engine", desc:"Silent, ultra-efficient engine offering up to 45 minutes of continuous flight at speeds reaching 120 mph."},
            {feature: "AI-Assisted Navigation", desc:"Real-time obstacle detection, automatic stabilization, and route optimization via onboard AI."},
            {feature: "Lightweight & Durable", desc:"Constructed with carbon-titanium alloy, weighing just 15 kg (33 lbs)."},
            {feature: "Eco-Friendly Power Source", desc:"Zero-emission quantum core, rechargeable with standard power outlets or solar charging pads."},
            {feature: "Advanced Safety Systems", desc:"Includes automatic emergency landing, collision avoidance, and biometric access control."},
            {feature: "Modular Design", desc:"Interchangeable thrusters and customizable external panels for personalized style."},
            {feature: "Compact Foldability", desc:"Easily foldable wings and thrusters for convenient storage and transport."}
        ],
        specs: [ 
            {key: "Flight Time", value: "Up to 45 minutes" },
            {key: "Maximum Speed", value: "120 mph (193 km/h)"},
            {key: "Weight", value: "15 kg (33 lbs)"},
            {key: "Materials", value: "Carbon-titanium alloy frame"},
            {key: "Power Source", value: "Rechargeable quantum core"},
            {key: "Charging Time", value: "90 minutes (standard outlet)"},
            {key: "Navigation System", value: "AI-assisted with obstacle detection"},
            {key: "Safety Features", value: "Emergency landing, collision avoidance, biometric access"},
            {key: "Dimensions", value: "60 cm x 45 cm x 35 cm (folded)"},
            {key: "Operating Temperature", value: "-20°C to 50°C (-4°F to 122°F)"},
            {key: "Connectivity", value: "Bluetooth 6.0, WiFi 7"},
            {key: "Maximum Payload", value: "120 kg (265 lbs)"}
        ],
        pricing: [
            {option: "Standard Package", price: 19999.00, includes: "Jet pack, charger, basic user manual"},
            {option: "Advanced Package", price: 24999.00, includes: "Standard + AI flight coach app + extended warranty (3 years)"},
            {option: "Premium Package", price: 29999.00, includes: "Advanced + custom design panels + on-site training"}
        ],
        accessories: [
            {option: "Solar Charging Pad", price: 499.00},
            {option: "Extra Modular Thrusters", price: 799.00},
            {option: "Protective Flight Helmet with HUD", price: 1199.00},
            {option: "Portable Flight Case", price: 299.00}
        ]
    },
    {
        name: "ChronoGlide™ Chair", 
        id: 2,
        image: "timeMachine.jpg",
        imageSmall: "timeMachine_small.jpg",
        desc: "Explore the past or future in comfort and safety in your personal gateway to time itself.",
        imageAlt: "ChronoGlide™ Chair",
        par1: "Unlock the secrets of time travel with the <strong>ChronoGlide™ Chair</strong>, the pinnacle of temporal exploration technology. Powered by advanced quantum entanglement drives and temporal field stabilizers, this device lets you navigate the past, present, and future with precision and safety.",
        par2: "Designed with user-friendly controls and a robust AI co-pilot, the ChronoGlide™  ensures safe journeys through time, allowing historians, scientists, and adventurers alike to witness moments lost to history or glimpse possible futures.",
        features: [
            {feature: "Quantum Entanglement Drive", desc:"Enables controlled temporal displacement up to 100 years forward or backward."},
            {feature: "Temporal Field Stabilizers", desc:"Maintain user safety and environmental integrity during time jumps."},
            {feature: "AI Co-Pilot Navigation", desc:"Provides real-time risk assessment and trajectory optimization."},
            {feature: "Holographic Interface", desc:"Intuitive controls displayed via a fully interactive 3D hologram."},
            {feature: "Temporal Data Recorder", desc:"Logs all visited timelines for review and analysis."},
            {feature: "Compact & Portable", desc:"Easily transported in its protective chrono-case."},
            {feature: "Failsafe Protocols", desc:"Automatic return to origin time in case of emergency."}
        ],
        specs: [ 
            {key: "Temporal Range", value: "±100 years" },
            {key: "Power Source", value: "Zero-point energy core" },
            {key: "Operation Time (per charge)", value: "Up to 2 hours" },
            {key: "Weight", value: "22 kg (48.5 lbs)" },
            {key: "Dimensions", value: "80 cm x 50 cm x 40 cm" },
            {key: "Navigation System", value: "AI-assisted holographic controls" },
            {key: "Safety Features", value: "Failsafe auto-return, temporal field stabilizers" },
            {key: "Connectivity", value: "Quantum encrypted WiFi, Bluetooth 6.0" },
            {key: "Operating Temperature", value: "10°C to 45°C (14°F to 113°F)" },
            {key: "Maximum Payload", value: "150 kg (330 lbs)" }
        ],
        pricing: [
            {option: "Standard Package", price: 99999.00, includes: "Time machine unit, charger, basic user manual"},
            {option: "Advanced Package", price: 129999.00, includes: "Standard + AI co-pilot upgrade + extended warranty (5 years)"},
            {option: "Premium Package", price: 149999.00, includes: "Advanced + custom chrono-case + on-site temporal training"}
        ],
        accessories: [
            {option: "Chrono-Calibration Toolkit", price: 2499.00},
            {option: "Temporal Field Booster", price: 4999.00},
            {option: "Protective Time Shield Suit", price: 7499.00},
            {option: "Portable Quantum Power Pack", price: 1999.00}
        ]
    },
    {
        name: "NeuroLift™ Booster Helmet",
        id: 3,
        image: "neuralBooster.jpg",
        imageSmall: "neuralBooster_small.jpg",
        desc: "Enhance your focus and intelligence in real time, letting you think faster and learn deeper.",
        imageAlt: "NeuroLift Booster",
        par1: "Unlock the full potential of your mind with the <strong>NeuroLift™ Booster</strong> helmet — a revolutionary neural interface that enhances cognitive speed, memory retention, and learning capacity. Whether you're a student, researcher, or creative professional, NeuroLift is your ultimate mental performance enhancer.",
        par2: "Designed with cutting-edge neuroadaptive technology and built for comfort, the helmet uses non-invasive neural stimulation and AI-guided cognitive feedback to help users think clearer, learn faster, and stay deeply focused for extended periods.",
        features: [
            {feature: "NeuroSync Engine", desc: "Boosts cognitive processing speed by up to 300% through real-time brainwave modulation."},
            {feature: "AI-Powered Focus Assist", desc: "Continuously monitors attention levels and gently redirects focus during tasks."},
            {feature: "Ergonomic & Lightweight", desc: "Precision-molded graphene-polymer shell weighing just 1.2 kg (2.6 lbs)."},
            {feature: "Adaptive Stimulation Modes", desc: "Customizable settings for study, creativity, meditation, or productivity."},
            {feature: "Safety First", desc: "EMF shielding, auto shut-off after overuse, and neural load balancing to prevent fatigue."},
            {feature: "Immersive Learning Hub", desc: "Integrated AR HUD for visual aids, memory cues, and note-taking overlays."},
            {feature: "Compact Storage Design", desc: "Detachable inner liner and fold-flat visor for easy portability."}
        ],
        specs: [
            {key: "Usage Time", value: "Up to 8 hours per session"},
            {key: "Weight", value: "1.2 kg (2.6 lbs)"},
            {key: "Materials", value: "Graphene-polymer composite shell"},
            {key: "Power Source", value: "Rechargeable neuro-capacitor (USB-C or wireless charging)"},
            {key: "Charging Time", value: "60 minutes"},
            {key: "Stimulation Modes", value: "Focus, Learn, Meditate, Creative Boost"},
            {key: "Safety Features", value: "Neural fatigue sensor, EMF shielding, timed usage lockout"},
            {key: "Dimensions", value: "28 cm x 24 cm x 18 cm"},
            {key: "Operating Temperature", value: "0°C to 40°C (32°F to 104°F)"},
            {key: "Connectivity", value: "Bluetooth 6.0, WiFi 7, NeuroCloud Sync"},
            {key: "User Profiles", value: "Multi-user with encrypted biometric access"}
        ],
        pricing: [
            {option: "Standard Package", price: 2499.00, includes: "Helmet, charging base, basic neuro-training app"},
            {option: "Advanced Package", price: 3299.00, includes: "Standard + FocusSync Pro app + 2-year warranty"},
            {option: "Premium Package", price: 4199.00, includes: "Advanced + custom fit liner + cognitive coaching sessions"}
        ],
        accessories: [
            {option: "Wireless Charging Dock", price: 149.00},
            {option: "Extra Inner Liners (washable)", price: 59.00},
            {option: "AR HUD Learning Lens Upgrade", price: 399.00},
            {option: "Protective Carry Case", price: 89.00}
        ]
    },
    {
        name: "PhantomWeave™ Phase-Shifting Suit",
        id: 4,
        image: "phasingSuit.jpg",
        imageSmall: "phasingSuit_small.jpg",
        desc: "Slip through solid matter by syncing your body out of phase with reality.",
        imageAlt: "PhantomWeave Phase-Shifting Suit",
        par1: "Step beyond the limits of physical reality with the <strong>PhantomWeave™ Suit</strong> — an advanced phase-shifting exosuit engineered for covert operatives, elite rescue units, and experimental tech pioneers. Powered by next-gen quantum tunneling arrays, this suit allows seamless passage through solid matter without leaving a trace.",
        par2: "Constructed from nano-adaptive meta-fabric and embedded with AI-regulated quantum filaments, the PhantomWeave™ reacts to your neural commands in real-time, phasing your body at a molecular level. Tactical, silent, and mind-bending — this is mobility redefined.",
        features: [
            {feature: "Quantum Tunneling Core", desc: "Enables controlled phase-shifting to bypass walls, floors, or obstacles up to 2 meters thick."},
            {feature: "NeuralLink Command System", desc: "Brain-responsive interface for seamless activation and deactivation of phase mode."},
            {feature: "Meta-Fabric Construction", desc: "Ultralight, adaptive weave that shifts density during phase transitions."},
            {feature: "Camouflage Cloaking", desc: "Optical and thermal concealment for maximum stealth during operation."},
            {feature: "Internal Life Support", desc: "Up to 30 minutes of oxygenation and vitals monitoring while phased."},
            {feature: "Fail-Safe Mechanism", desc: "Auto-reversion protocols with multi-layer quantum anchor locks."},
            {feature: "Compact Deployment", desc: "Folds into a briefcase-sized container for transport and quick assembly."}
        ],
        specs: [
            {key: "Phase Duration", value: "Up to 180 seconds per cycle"},
            {key: "Recharge Time", value: "15 minutes (standard power cell)"},
            {key: "Weight", value: "9 kg (19.8 lbs)"},
            {key: "Materials", value: "Meta-fabric, graphene-nanotube mesh, quantum threads"},
            {key: "Power Source", value: "Dual-core quantum capacitor system"},
            {key: "Control Interface", value: "NeuralLink V4, tactile backup panel"},
            {key: "Safety Features", value: "Auto phase reversion, anomaly detection, suit-lock override"},
            {key: "Dimensions (stored)", value: "40 cm x 30 cm x 12 cm"},
            {key: "Operating Temperature", value: "-40°C to 60°C (-40°F to 140°F)"},
            {key: "Connectivity", value: "QuantumNet sync, secure offline mode"},
            {key: "Compatibility", value: "NeuroLift™, AegisShield™ systems"}
        ],
        pricing: [
            {option: "Standard Package", price: 149000.00, includes: "Suit, neural calibrator, single-core power cell"},
            {option: "Advanced Package", price: 189000.00, includes: "Standard + dual-core power module + enhanced camouflage"},
            {option: "Elite Package", price: 239000.00, includes: "Advanced + remote ops kit + 1-year covert field support"}
        ],
        accessories: [
            {option: "Extra Quantum Power Cell", price: 7499.00},
            {option: "Mobile Recharge Station", price: 2499.00},
            {option: "Phase Residue Analyzer", price: 4199.00},
            {option: "Hardened Tactical Carry Case", price: 999.00}
        ]
    },
    {
        name: "SpectraVex™ Cloaking Suit",
        id: 5,
        image: "cloakingSuit.jpg",
        imageSmall: "cloakingSuit_small.jpg",
        desc: "Vanish from sight and sensors alike, moving unseen through any environment.",
        imageAlt: "SpectraVex™ Cloaking Suit",
        par1: "Disappear in plain sight with the <strong>SpectraVex™ Cloaking Suit</strong> — a breakthrough in stealth technology that renders the wearer completely invisible to both the human eye and digital surveillance systems. Whether you're conducting recon, escaping detection, or simply exploring without being seen, SpectraVex™ makes invisibility real.",
        par2: "Utilizing a hybrid of light-bending meta-materials and adaptive thermal masking, the suit blends seamlessly into any environment. With real-time terrain mapping and motion-based feedback, SpectraVex™ offers unmatched stealth, agility, and tactical advantage — all controlled intuitively through a smart neural interface.",
        features: [
            {feature: "Adaptive Cloaking Matrix", desc: "Refracts visible light and near-IR to render wearer visually invisible."},
            {feature: "Sensor Masking", desc: "Blocks heat signatures, electromagnetic emissions, and radar/sonar pings."},
            {feature: "Environmental Camouflage AI", desc: "Dynamically maps surroundings for real-time terrain mirroring."},
            {feature: "Smart NeuralLink Controls", desc: "Activate/deactivate invisibility with thought-command or manual touchpad."},
            {feature: "Silent Motion Tech", desc: "Integrated noise-dampening actuators for stealth movement."},
            {feature: "Emergency Disengage", desc: "Rapid cloak deactivation and signal beacon in critical situations."},
            {feature: "Weatherproof Design", desc: "Resistant to rain, dust, and extreme temperatures for full-terrain deployment."}
        ],
        specs: [
            {key: "Cloaking Duration", value: "Up to 25 minutes (continuous)"},
            {key: "Recharge Time", value: "20 minutes (via rapid dock)"},
            {key: "Weight", value: "6.5 kg (14.3 lbs)"},
            {key: "Materials", value: "Meta-reflective fibers, thermal-dampened mesh, sensor-absorbing polymers"},
            {key: "Power Source", value: "Dual microfusion cells"},
            {key: "Control Interface", value: "NeuralLink V3.2 + backup tactile panel"},
            {key: "Stealth Features", value: "Visual cloak, thermal masking, sound suppression, EMF blackout"},
            {key: "Dimensions (stored)", value: "45 cm x 28 cm x 10 cm"},
            {key: "Operating Temperature", value: "-30°C to 55°C (-22°F to 131°F)"},
            {key: "Connectivity", value: "Secure offline mode, encrypted NeuralNet handshake"},
            {key: "Suit Modes", value: "Full Cloak, Partial Camouflage, Sensor Mask Only"}
        ],
        pricing: [
            {option: "Standard Package", price: 98000.00, includes: "Cloaking suit, neural interface module, rapid charger"},
            {option: "Tactical Package", price: 129000.00, includes: "Standard + tactical HUD link + sensor interference upgrade"},
            {option: "Elite Package", price: 159000.00, includes: "Tactical + extended power cells + field recalibration unit"}
        ],
        accessories: [
            {option: "Extended Microfusion Cell Pack", price: 5999.00},
            {option: "HUD Integration Kit", price: 3499.00},
            {option: "Terrain Feedback Boots", price: 2199.00},
            {option: "EMF Decoy Beacon", price: 1799.00},
            {option: "Shockproof Carry Case", price: 799.00}
        ]
    },
    {
        name: "VortexGate™ Transporter",
        id: 6,
        image: "portalTransporter.jpg",
        imageSmall: "portalTransporter_small.jpg",
        desc: "Travel anywhere in an instant, folding space to take you from here to there without the journey.",
        imageAlt: "VortexGate™ Portal Transporter",
        par1: "Break the boundaries of space with the <strong>VortexGate™ Transporter</strong> — the world’s most advanced personal teleportation device, using stabilized portal mechanics to instantly relocate users to any mapped destination on Earth. No roads, no delays, no limits.",
        par2: "Leveraging quantum entanglement matrices and phase-lock spatial anchors, the VortexGate™ opens short-lived wormholes with pinpoint accuracy. Compact, secure, and surprisingly intuitive, it redefines global mobility for explorers, emergency responders, and elite operatives alike.",
        features: [
            {feature: "Instantaneous Travel", desc: "Open one-way or two-way portals to any geotagged location within planetary bounds."},
            {feature: "Quantum Spatial Anchoring", desc: "Lock destination coordinates with less than 2 cm deviation."},
            {feature: "Multi-Layer Safety Protocols", desc: "Auto-failovers, environmental checks, and biometric lockout."},
            {feature: "Portable Design", desc: "Collapsible ring-form transporter deploys in under 10 seconds."},
            {feature: "Environmental Shielding", desc: "Stabilizes wormhole path against wind, water, and thermal anomalies."},
            {feature: "Secure Interface", desc: "Encrypted control core with biometric and neural input modes."},
            {feature: "Offline Functionality", desc: "Pre-load up to 10 destinations for no-signal environments."}
        ],
        specs: [
            {key: "Teleport Range", value: "Anywhere on Earth"},
            {key: "Activation Time", value: "6 seconds (average)"},
            {key: "Weight", value: "12.5 kg (27.6 lbs)"},
            {key: "Materials", value: "Titanium-ceramic composite frame with anti-resonance plating"},
            {key: "Power Source", value: "Tri-core graviton cell with auxiliary fusion booster"},
            {key: "Recharge Time", value: "2 hours (full cycle) / 30 min (quick jump)"},
            {key: "Control Interface", value: "Touchscreen HUD + optional NeuralLink input"},
            {key: "Safety Features", value: "Interference detection, coordinate verification, auto-shutdown override"},
            {key: "Dimensions (stored)", value: "55 cm x 40 cm x 20 cm"},
            {key: "Operating Temperature", value: "-10°C to 50°C (14°F to 122°F)"},
            {key: "Connectivity", value: "QuantumLink Sync, Satellite GPS fallback"},
            {key: "Destination Storage", value: "10 offline slots, unlimited cloud storage"}
        ],
        pricing: [
            {option: "Standard Package", price: 399000.00, includes: "Transporter unit, power cell, carry module, quick start guide"},
            {option: "Pro Package", price: 479000.00, includes: "Standard + NeuralLink input + tactical cloak module + 3-year service plan"},
            {option: "Global Elite Package", price: 599000.00, includes: "Pro + unlimited destination sync + priority airlift support"}
        ],
        accessories: [
            {option: "Extra Graviton Power Cell", price: 19999.00},
            {option: "Portable Energy Dock", price: 8499.00},
            {option: "HoloMap Terrain Scanner", price: 5299.00},
            {option: "Secure Reinforced Travel Case", price: 2199.00},
            {option: "NeuralLink Headset (Pro+)", price: 3799.00}
        ]
    }
];
