// test basic

PersonStack ps = createStack();

//
// create a stack
//

printf("==============================------------------------------\n");
printf("createStack()\n");

printf("isEmpty() == true ## ");
if (isEmpty(&ps) )
	printf("pass\n");
else
	printf("fail\n");


printf("stackSize() == 0 ## ");
if (stackSize(&ps) == 0)
	printf("pass\n");
else
	printf("fail\n");

//
// add a person
// 

char* s = malloc(100);
strcpy(s,"one");
Person p = {s,1};


printf("==============================------------------------------\n");
printf("pushPerson()\n");
pushPerson(&ps, p);
printf("stackSize() == 1 ## ");
if (stackSize(&ps) == 1)
	printf("pass\n");
else
	printf("fail\n");

printf("isEmpty() == false ## ");
if (!isEmpty(&ps) )
	printf("pass\n");
else
	printf("fail\n");


printf("print() \n");
printf("++--\n");
print(&ps);
printf("++--\n");



//
// remove a person
//

printf("==============================------------------------------\n");

printf("pop()\n");
pop(&ps);
printf("stackSize() == 0 ## ");
if (stackSize(&ps) == 0)
	printf("pass\n");
else
	printf("fail\n");

printf("stackSize() == 0 ## ");
if (stackSize(&ps) == 0)
	printf("pass\n");
else
	printf("fail\n");

//
// add multiple people
//

printf("==============================------------------------------\n");

printf("push()\n");

p.age = 11;
pushPerson(&ps, p);
printf("stackSize() == 1 ## ");
if (stackSize(&ps) == 1)
	printf("pass\n");
else
	printf("fail\n");

printf("isEmpty() == false ## ");
if (!isEmpty(&ps) )
	printf("pass\n");
else
	printf("fail\n");


printf("print() \n");
printf("++--\n");
print(&ps);
printf("++--\n");

printf("push()\n");

strcpy(s,"second");
p.age = 22;
pushPerson(&ps, p);

printf("stackSize() == 2 ## ");
if (stackSize(&ps) == 2)
	printf("pass\n");
else
	printf("fail\n");

printf("isEmpty() == false ## ");
if (!isEmpty(&ps) )
	printf("pass\n");
else
	printf("fail\n");


printf("print() \n");
printf("++--\n");
print(&ps);
printf("++--\n");


printf("==============================------------------------------\n");

printf("reverse()\n");
reverse(&ps);

printf("print() \n");
printf("++--\n");
print(&ps);
printf("++--\n");


printf("==============================------------------------------\n");


int nnn = 3;
PersonStack ps2;
ps2 = createStack();
for(int i=0; i<nnn; i+=1){
	push(&ps2, s, i+i*10+i*100);
}
printf("new stack of %d elements\n", nnn);
bool pass = 1;
for(int i=0; i<nnn; i+=1){
	Person tmp = pop(&ps2);
	pass = pass && (tmp.age == ((nnn-1-i)+(nnn-1-i)*10+(nnn-1-i)*100));
}
printf("push/pop %d elements ## ", nnn);
if (pass)
	printf("pass\n");
else
	printf("fail\n");

ps2 = createStack();
for(int i=0; i<nnn; i+=1){
	push(&ps2, s, i+i*10+i*100);
}

printf("stackSize() == %d ## ", nnn);
if (stackSize(&ps2) == nnn)
	printf("pass\n");
else
	printf("fail\n");


printf("reverse()\n");
reverse(&ps2);
printf("stackSize() == %d ## ", nnn);
if (stackSize(&ps2) == nnn)
	printf("pass\n");
else
	printf("fail\n");

pass = true;
for(int i=0; i<nnn; i+=1){
	pass = pass && (pop(&ps2).age == ((i)+(i)*10+(i)*100));
}
printf("reverse test ## ");
if (pass)
	printf("pass\n");
else
	printf("fail\n");
 
printf("==============================------------------------------\n");


nnn = 65535+25;
ps2 = createStack();
for(int i=0; i<nnn; i+=1){
	push(&ps2, s, i+i*10+i*100);
}
printf("new stack of %d elements\n", nnn);
pass = 1;
for(int i=0; i<nnn; i+=1){
	Person tmp = pop(&ps2);
	pass = pass && (tmp.age == ((nnn-1-i)+(nnn-1-i)*10+(nnn-1-i)*100));
}
printf("push/pop %d elements ## ", nnn);
if (pass)
	printf("pass\n");
else
	printf("fail\n");

ps2 = createStack();
for(int i=0; i<nnn; i+=1){
	push(&ps2, s, i+i*10+i*100);
}

printf("stackSize() == %d ## ", nnn);
if (stackSize(&ps2) == nnn)
	printf("pass\n");
else
	printf("fail\n");


printf("reverse()\n");
reverse(&ps2);
printf("stackSize() == %d ## ", nnn);
if (stackSize(&ps2) == nnn)
	printf("pass\n");
else
	printf("fail\n");

pass = true;
for(int i=0; i<nnn; i+=1){
	pass = pass && (pop(&ps2).age == ((i)+(i)*10+(i)*100));
}
printf("reverse test ## ");
if (pass)
	printf("pass\n");
else
	printf("fail\n");
 







printf("==============================------------------------------\n");





//unsigned short stackSize(const PersonStack* stack)
  // Returns 0 if the size of the stack is zero
  // Returns 0 if the size of the stack is larger
  //           than can be stored in an unsigned short
  // Returns the size of the stack otherwise


//void pushPerson(PersonStack* stack, Person p)
 // Adds Person p to the stack passed into the function


//void push(PersonStack* stack, char* name, int age)
 // adds a Person, defined by name and age, 
 // to the stack passed into the function


//Person pop(PersonStack* stack)
 // Removes and returns the Person currently on the top
 // of the stack passed into the function
 // Precondition: stack must have size >= 1

//void print(const PersonStack* stack)
  // Prints the contents of the stack to the screen
  // in order from the top to the bottom of the stack
  // The output for each person should be a single line
  // "name : age \n"
  // (name followed by colon followed by age followed by newline)


//void reverse(PersonStack* stack)
  // reverses the order of the stack


//void kill(PersonStack* stack)

return 0;
